<?php
/**
 * Shopware 5
 * Copyright (c) shopware AG
 *
 * According to our dual licensing model, this program can be used either
 * under the terms of the GNU Affero General Public License, version 3,
 * or under a proprietary license.
 *
 * The texts of the GNU Affero General Public License with an additional
 * permission and of our proprietary license can be found at and
 * in the LICENSE file you have received along with this program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * "Shopware" is a registered trademark of shopware AG.
 * The licensing of the program under the AGPLv3 does not imply a
 * trademark license. Therefore any rights, title and interest in
 * our trademarks remain entirely with us.
 */

namespace Shopware\Bundle\SearchBundle\Condition;

use Shopware\Bundle\SearchBundle\ConditionInterface;

/**
 * @category  Shopware
 * @package   Shopware\Bundle\SearchBundle\Condition
 * @copyright Copyright (c) shopware AG (http://www.shopware.com)
 */
class OrdernumberCondition implements ConditionInterface
{
    /**
     * @var string[]
     */
    private $ordernumbers;

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return 'ordernumber';
    }

    /**
     * @param string[] $ordernumbers
     */
    public function __construct(array $ordernumbers)
    {
        $this->ordernumbers = $ordernumbers;
    }

    /**
     * @return string[]
     */
    public function getOrdernumbers()
    {
        return $this->ordernumbers;
    }
}
